import { Model, DataTypes } from 'sequelize';

class Certificate extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        userId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        },
        title: {
          type: DataTypes.STRING,
          allowNull: false
        },
        description: {
          type: DataTypes.TEXT,
          allowNull: true
        },
        pdfUrl: {
          type: DataTypes.STRING,
          allowNull: true
        },
        imageUrl: {
          type: DataTypes.STRING,
          allowNull: true
        },
        issuedAt: {
          type: DataTypes.DATE,
          allowNull: false,
          defaultValue: DataTypes.NOW
        },
        validUntil: {
          type: DataTypes.DATE,
          allowNull: true
        },
        verificationId: {
          type: DataTypes.STRING,
          allowNull: false,
          unique: true
        },
        metadata: {
          type: DataTypes.JSON,
          defaultValue: {}
        }
      },
      {
        sequelize,
        modelName: 'certificate',
        timestamps: true
      }
    );
  }

  // Define associations
  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
  }
}

export default Certificate;