import { Model, DataTypes } from 'sequelize';

class CustomCTFPage extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        title: {
          type: DataTypes.STRING,
          allowNull: false,
          validate: {
            notEmpty: true,
            len: [3, 200]
          }
        },
        html: {
          type: DataTypes.TEXT,
          allowNull: false
        },
        css: {
          type: DataTypes.TEXT,
          allowNull: false
        },
        assets: {
          type: DataTypes.JSON,
          defaultValue: []
        },
        status: {
          type: DataTypes.ENUM('draft', 'published'),
          defaultValue: 'draft'
        },
        creatorId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        },
        ctfId: {
          type: DataTypes.UUID,
          allowNull: true,
          references: {
            model: 'ctfs',
            key: 'id'
          }
        },
        metadata: {
          type: DataTypes.JSON,
          defaultValue: {}
        }
      },
      {
        sequelize,
        modelName: 'custom_ctf_page',
        timestamps: true
      }
    );
  }

  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'creatorId', as: 'creator' });
    this.belongsTo(models.CTF, { foreignKey: 'ctfId', as: 'ctf' });
  }
}

export default CustomCTFPage;