import sequelize from '../utils/database.js';
import logger from '../utils/logger.js';

// Import models
import User from './User.js';
import CTF from './CTF.js';
import Challenge from './Challenge.js';
import Submission from './Submission.js';
import Notification from './Notification.js';
import Setting from './Setting.js';
import Session from './Session.js';
import Achievement from './Achievement.js';
import Certificate from './Certificate.js';
import LearningPath from './LearningPath.js';
import CustomCTFPage from './CustomCTFPage.js';

// Initialize models
const models = {
  User: User.init(sequelize),
  CTF: CTF.init(sequelize),
  Challenge: Challenge.init(sequelize),
  Submission: Submission.init(sequelize),
  Notification: Notification.init(sequelize),
  Setting: Setting.init(sequelize),
  Session: Session.init(sequelize),
  Achievement: Achievement.init(sequelize),
  Certificate: Certificate.init(sequelize),
  LearningPath: LearningPath.init(sequelize),
  CustomCTFPage: CustomCTFPage.init(sequelize)

};

// Add sequelize to the models object explicitly
models.sequelize = sequelize;

// Set up associations
Object.values(models)
  .filter(model => typeof model.associate === 'function')
  .forEach(model => model.associate(models));

// Export models
export { sequelize };  
export default models;