import express from 'express';
import { getMemberCTFs, getMemberStats } from '../controllers/member.controller.js';
import { authenticate, authorize } from '../middleware/auth.js';

const router = express.Router();

// Apply member authorization to all routes
router.use(authenticate, authorize('can_create_ctf'));

// Get all CTFs created by the member
router.get('/ctfs', getMemberCTFs);

// Get member statistics
router.get('/stats', getMemberStats);

export default router;