import express from 'express';
import { getNotifications, markAsRead, markAllAsRead, deleteNotification } from '../controllers/notification.controller.js';
import { ownershipCheck } from '../middleware/auth.js';

const router = express.Router();

// Get all notifications for the authenticated user
router.get('/', getNotifications);

// Mark a notification as read
router.put('/:id/read', ownershipCheck('Notification', 'id', 'userId'), markAsRead);

// Mark all notifications as read
router.put('/read-all', markAllAsRead);

// Delete a notification
router.delete('/:id', ownershipCheck('Notification', 'id', 'userId'), deleteNotification);

export default router;