import { sequelize } from '../models/index.js';
import { QueryTypes } from 'sequelize';

export const getLeaderboard = async (req, res) => {
  try {
    const limit = parseInt(req.query.limit) || 10;
    const offset = parseInt(req.query.offset) || 0;

    const leaderboardQuery = `
      SELECT
        u.id,
        u.name,
        u."avatarUrl",
        COALESCE(SUM(s."pointsAwarded"), 0) AS "totalPoints"
      FROM users u
      LEFT JOIN submissions s ON s."userId" = u.id AND s.correct = true
      GROUP BY u.id
      ORDER BY "totalPoints" DESC
      LIMIT :limit OFFSET :offset;
    `;

    const results = await sequelize.query(leaderboardQuery, {
      replacements: { limit, offset },
      type: QueryTypes.SELECT
    });

    res.status(200).json({ success: true, data: results });
  } catch (error) {
    console.error('Error fetching leaderboard:', error);
    res.status(500).json({ success: false, message: 'Failed to fetch leaderboard', error });
  }
};