import { Model, DataTypes } from 'sequelize';

class LearningPath extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        title: {
          type: DataTypes.STRING,
          allowNull: false
        },
        description: {
          type: DataTypes.TEXT,
          allowNull: false
        },
        level: {
          type: DataTypes.ENUM('beginner', 'intermediate', 'advanced'),
          allowNull: false
        },
        category: {
          type: DataTypes.STRING,
          allowNull: false
        },
        steps: {
          type: DataTypes.JSON,
          allowNull: false,
          comment: 'Ordered array of steps with challenges, resources, etc.'
        },
        estimatedHours: {
          type: DataTypes.INTEGER,
          allowNull: true
        },
        isActive: {
          type: DataTypes.BOOLEAN,
          defaultValue: true
        },
        certificateId: {
          type: DataTypes.UUID,
          allowNull: true
        },
        createdBy: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        }
      },
      {
        sequelize,
        modelName: 'learning_path',
        timestamps: true
      }
    );
  }

  // Define associations
  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'createdBy', as: 'creator' });
  }
}

export default LearningPath;