import { Model, DataTypes } from 'sequelize';

class Notification extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true,
        },
        userId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id',
          },
          field: 'user_id', // maps to user_id column in DB
        },
        type: {
          type: DataTypes.STRING,
          allowNull: false,
        },
        message: {
          type: DataTypes.STRING,
          allowNull: false,
        },
        read: {
          type: DataTypes.BOOLEAN,
          defaultValue: false,
        },
        actionUrl: {
          type: DataTypes.STRING,
          allowNull: true,
          field: 'action_url',
        },
        metadata: {
          type: DataTypes.JSON,
          defaultValue: {},
        },
        expiresAt: {
          type: DataTypes.DATE,
          allowNull: true,
          field: 'expires_at',
        },
      },
      {
        sequelize,
        modelName: 'notification',
        timestamps: true,
        indexes: [
          {
            fields: ['user_id', 'read'], // use DB column names here
          },
        ],
      }
    );
  }

  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
  }
}

export default Notification;