import { Model, DataTypes } from 'sequelize';

class Session extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        userId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        },
        refreshToken: {
          type: DataTypes.STRING,
          allowNull: false
        },
        userAgent: {
          type: DataTypes.STRING,
          allowNull: true
        },
        ipAddress: {
          type: DataTypes.STRING,
          allowNull: true
        },
        expiresAt: {
          type: DataTypes.DATE,
          allowNull: false
        },
        isRevoked: {
          type: DataTypes.BOOLEAN,
          defaultValue: false
        }
      },
      {
        sequelize,
        modelName: 'session',
        timestamps: true,
        indexes: [
          {
            fields: ['refreshToken']
          },
          {
            fields: ['userId']
          }
        ]
      }
    );
  }

  // Define associations
  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
  }
}

export default Session;