import { Model, DataTypes } from 'sequelize';

class Submission extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        userId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        },
        challengeId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'challenges',
            key: 'id'
          }
        },
        flag: {
          type: DataTypes.STRING,
          allowNull: false
        },
        correct: {
          type: DataTypes.BOOLEAN,
          allowNull: false
        },
        pointsAwarded: {
          type: DataTypes.INTEGER,
          defaultValue: 0
        },
        attemptNumber: {
          type: DataTypes.INTEGER,
          defaultValue: 1
        },
        ipAddress: {
          type: DataTypes.STRING,
          allowNull: true
        },
        userAgent: {
          type: DataTypes.STRING,
          allowNull: true
        },
        solveTime: {
          type: DataTypes.INTEGER,
          allowNull: true,
          comment: 'Time taken to solve in seconds'
        }
      },
      {
        sequelize,
        modelName: 'submission',
        timestamps: true
      }
    );
  }

  // Define associations
  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
    this.belongsTo(models.Challenge, { foreignKey: 'challengeId', as: 'challenge' });
  }
}

export default Submission;