import express from 'express';
import { getUserDashboard, getMemberDashboard, getPublicDashboard } from '../controllers/dashboard.controller.js';
import { authenticate, authorize } from '../middleware/auth.js';

const router = express.Router();

// Public dashboard - no authentication required (basic stats)
router.get('/public', getPublicDashboard);

// User dashboard - accessible by all authenticated users
router.get('/user', authenticate, getUserDashboard);

// Member dashboard - only accessible by members and admins
router.get('/member', authenticate, authorize('can_create_ctf'), getMemberDashboard);

export default router;