import express from 'express';
import authRoutes from './auth.routes.js';
import userRoutes from './user.routes.js';
import profileRoutes from './profile.routes.js';
import adminRoutes from './admin.routes.js';
import memberRoutes from './member.routes.js';
import ctfRoutes from './ctf.routes.js';
import challengeRoutes from './challenge.routes.js';
import notificationRoutes from './notification.routes.js';
import { authenticate } from '../middleware/auth.js';
import leaderboardRoutes from './leaderboard.routes.js';
import dashboardRoutes from './dashboard.routes.js';
import customCTFRoutes from './customCTF.routes.js';

const router = express.Router();

// Public routes
router.use('/auth', authRoutes);

// Protected routes (require authentication)
router.use('/dashboard', dashboardRoutes);
router.use('/profile', authenticate, profileRoutes);
router.use('/user', authenticate, userRoutes);
router.use('/admin', authenticate, adminRoutes);
router.use('/member', authenticate, memberRoutes);
router.use('/ctfs', authenticate, ctfRoutes);
router.use('/challenges', authenticate, challengeRoutes);
// router.use('/notifications', authenticate, notificationRoutes);
router.use('/leaderboard', authenticate, leaderboardRoutes);
router.use('/custom-ctf', authenticate, customCTFRoutes);


export default router;