import 'dotenv/config';
import app from './app.js';
import sequelize from './utils/database.js';
import logger from './utils/logger.js';

const PORT = process.env.PORT || 3000;

// Handle uncaught exceptions
process.on('uncaughtException', (error) => {
  logger.error('Uncaught Exception:', error);
  process.exit(1);
});

// Handle unhandled promise rejections
process.on('unhandledRejection', (reason, promise) => {
  logger.error('Unhandled Rejection at:', promise, 'reason:', reason);
});
 
// Test PostgreSQL database connection
const testDatabaseConnection = async () => {
  try {
    await sequelize.authenticate();
    logger.info('✅ PostgreSQL connection established successfully');
  } catch (error) {
    logger.error('❌ Database connection error:', error);
    process.exit(1);
  }
};

// Start the server
const startServer = async () => {
  try {
    await testDatabaseConnection();
    await sequelize.sync({ alter: false }); // Set to false to avoid conflicts with existing tables
    app.listen(PORT, () => {
      logger.info(`🚀 Server running on port ${PORT} in ${process.env.NODE_ENV} mode`);
    });
  } catch (error) {
    logger.error('❌ Server startup error:', error);
    process.exit(1);
  }
};

startServer();