import { sequelize } from '../models/index.js';
import logger from '../utils/logger.js';

const migrate = async () => {
  try {
    // Force sync all models with the database
    await sequelize.sync({ force: true });
    logger.info('Database migration completed successfully - Tables have been created');
    process.exit(0);
  } catch (error) {
    logger.error('Database migration failed:', error);
    process.exit(1);
  }
};

migrate(); 