import { Model, DataTypes } from 'sequelize';

class Achievement extends Model {
  static init(sequelize) {
    return super.init(
      {
        id: {
          type: DataTypes.UUID,
          defaultValue: DataTypes.UUIDV4,
          primaryKey: true
        },
        userId: {
          type: DataTypes.UUID,
          allowNull: false,
          references: {
            model: 'users',
            key: 'id'
          }
        },
        title: {
          type: DataTypes.STRING,
          allowNull: false
        },
        description: {
          type: DataTypes.STRING,
          allowNull: false
        },
        iconUrl: {
          type: DataTypes.STRING,
          allowNull: true
        },
        criteria: {
          type: DataTypes.JSON,
          allowNull: true,
          comment: 'JSON data describing how this achievement was earned'
        },
        earnedAt: {
          type: DataTypes.DATE,
          allowNull: false,
          defaultValue: DataTypes.NOW
        },
        category: {
          type: DataTypes.STRING,
          allowNull: false
        },
        points: {
          type: DataTypes.INTEGER,
          allowNull: false,
          defaultValue: 0
        }
      },
      {
        sequelize,
        modelName: 'achievement',
        timestamps: true
      }
    );
  }

  // Define associations
  static associate(models) {
    this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
  }
}

export default Achievement;