import { Model, DataTypes } from 'sequelize';

class Setting extends Model {
  static init(sequelize) {
    return super.init(
      {
        key: {
          type: DataTypes.STRING,
          primaryKey: true,
          allowNull: false
        },
        value: {
          type: DataTypes.JSON,
          allowNull: false
        },
        description: {
          type: DataTypes.STRING,
          allowNull: true
        },
        category: {
          type: DataTypes.STRING,
          allowNull: false
        }
      },
      {
        sequelize,
        modelName: 'setting',
        timestamps: true
      }
    );
  }

  // No direct associations for settings
  static associate(models) {}
}

export default Setting;