import express from 'express';
import { getUserProgress, getActiveChallenges, getLearningPaths } from '../controllers/user.controller.js';
import { authenticate } from '../middleware/auth.js';
import { getDashboard } from '../controllers/admin.controller.js';

const router = express.Router();

// Apply authentication to all routes
router.use(authenticate);

// Get user progress and ranking
router.get('/progress', getUserProgress);

// Get active challenges
router.get('/challenges/active', getActiveChallenges);

// Get learning paths
router.get('/learning', getLearningPaths);
router.get('/dashboard', getDashboard);

export default router;