import jwt from 'jsonwebtoken';
import crypto from 'crypto';

// Generate JWT access token
export const generateAccessToken = (userId) => {
  return jwt.sign(
    { userId },
    process.env.JWT_SECRET,
    { expiresIn: process.env.JWT_ACCESS_EXPIRY || '15m' }
  );
};

// Generate JWT refresh token
export const generateRefreshToken = () => {
  return crypto.randomBytes(40).toString('hex');
};

// Verify JWT token
export const verifyToken = (token) => {
  try {
    return jwt.verify(token, process.env.JWT_SECRET);
  } catch (error) {
    throw error;
  }
};

// Generate random token for password reset or email verification
export const generateRandomToken = () => {
  return crypto.randomBytes(32).toString('hex');
};

// Generate a token pair (access + refresh)
export const generateTokenPair = (userId) => {
  const accessToken = generateAccessToken(userId);
  const refreshToken = generateRefreshToken();
  
  return {
    accessToken,
    refreshToken
  };
};